(define/contract (min-groups intervals)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define sorted (sort intervals (lambda (a b) (< (car a) (car b)))))
  (define heap (make-heap (lambda (a b) (< a b))))
  (heap-add! heap 0)
  (for ([interval sorted])
    (define start (car interval))
    (define end (cadr interval))
    (if (<= start (heap-min heap))
        (heap-add! heap end)
        (begin
          (heap-remove-min! heap)
          (heap-add! heap end))))
  (heap-count heap))