(define (minimum-money transactions)
  (define (sum-negative x)
    (for/sum ([t transactions] #:when (< (- (cadr t) (car t)) 0))
      (- (car t) (cadr t))))
  (define max-loss 0)
  (define max-cost 0)
  (for ([t transactions])
    (define cost (car t))
    (define cashback (cadr t))
    (define loss (- cost cashback))
    (when (> loss max-loss)
      (set! max-loss loss))
    (when (> cost max-cost)
      (set! max-cost cost)))
  (max (sum-negative) (- max-cost max-loss)))