(define/contract (sum-prefix-scores words)
  (-> (listof string?) (listof exact-integer?))
  (define trie (make-hash))
  (for ([word words])
    (define node trie)
    (for ([ch word])
      (unless (hash-has-key? node ch)
        (hash-set! node ch (make-hash)))
      (set! node (hash-ref node ch))
      (hash-update! node 'count (lambda (x) (add1 x)) 0)))

  (define result '())
  (for ([word words])
    (define score 0)
    (define node trie)
    (for ([ch word])
      (set! node (hash-ref node ch))
      (set! score (+ score (hash-ref node 'count))))
    (set! result (cons score result)))
  (reverse result))