(define/contract (max-sum grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define m (length grid))
  (define n (if (null? grid) 0 (length (car grid))))
  (define max-sum -inf.0)
  (for ([i (in-range (- m 2))])
    (for ([j (in-range (- n 2))])
      (define sum (+ (list-ref (list-ref grid i) j)
                     (list-ref (list-ref grid i) (+ j 1))
                     (list-ref (list-ref grid i) (+ j 2))
                     (list-ref (list-ref grid (+ i 1)) (+ j 1))
                     (list-ref (list-ref grid (+ i 2)) j)
                     (list-ref (list-ref grid (+ i 2)) (+ j 1))
                     (list-ref (list-ref grid (+ i 2)) (+ j 2))))
      (when (> sum max-sum)
        (set! max-sum sum)))
  (if (= max-sum -inf.0) 0 max-sum))