(define/contract (subarrays-with-gcd-equal-to-k nums k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length nums))
  (define count 0)
  (for ([i (in-range n)])
    (define current-gcd 0)
    (for ([j (in-range i n)])
      (set! current-gcd (gcd current-gcd (list-ref nums j)))
      (if (= current-gcd k)
          (set! count (add1 count))
          (when (< current-gcd k)
            (break))))
  count)