(define/contract (best-closing-time customers)
  (-> string? exact-integer?)
  (define n (string-length customers))
  (define prefix (make-vector (add1 n) 0))
  (for ([i (in-range 1 (add1 n))])
    (vector-set! prefix i (+ (vector-ref prefix (sub1 i)) 
                            (if (char=? (string-ref customers (sub1 i)) #\N) 1 0)))
  (define suffix (make-vector (add1 n) 0))
  (for ([i (in-range (sub1 n) -1 -1)])
    (vector-set! suffix i (+ (vector-ref suffix (add1 i)) 
                            (if (char=? (string-ref customers i) #\Y) 1 0)))
  (define min-penalty +inf.0)
  (define result 0)
  (for ([i (in-range (add1 n))])
    (define penalty (+ (vector-ref prefix i) (vector-ref suffix i)))
    (when (< penalty min-penalty)
      (set! min-penalty penalty)
      (set! result i)))
  result)