(define/contract (is-circular-sentence sentence)
  (-> string? boolean?)
  (let* ([words (string-split sentence)]
         [n (length words)])
    (if (= n 1)
        (let ([word (car words)])
          (equal? (string-ref word 0) (string-ref word (sub1 (string-length word)))))
        (let loop ([i 0])
          (if (= i (sub1 n))
              (equal? (string-ref (list-ref words i) (sub1 (string-length (list-ref words i))))
                      (string-ref (list-ref words 0) 0))
              (and (equal? (string-ref (list-ref words i) (sub1 (string-length (list-ref words i))))
                   (string-ref (list-ref words (add1 i)) 0)
                   (loop (add1 i))))))))