#lang racket

(define (magnificent-sets n edges)
  (define adj (make-vector n '()))
  (for ([edge edges])
    (let ([u (sub1 (first edge))]
          [v (sub1 (second edge))])
      (vector-set! adj u (cons v (vector-ref adj u)))
      (vector-set! adj v (cons u (vector-ref adj v)))))

  (define visited (make-vector n #f))
  (define max-groups 0)

  (define (bfs start)
    (define queue (make-queue))
    (define levels (make-vector n -1))
    (enqueue! queue start)
    (vector-set! levels start 1)
    (vector-set! visited start #t)
    (define max-level 1)

    (let loop ()
      (unless (queue-empty? queue)
        (let ([u (dequeue! queue)])
          (for ([v (vector-ref adj u)])
            (when (= (vector-ref levels v) -1)
              (vector-set! levels v (+ (vector-ref levels u) 1))
              (enqueue! queue v)
              (set! max-level (max max-level (vector-ref levels v)))
              (vector-set! visited v #t))
            (when (not (= (abs (- (vector-ref levels v) (vector-ref levels u))) 1)
              (set! max-level -1)
              (queue-clear! queue))))
        (loop)))
    max-level)

  (for ([i (in-range n)])
    (unless (vector-ref visited i)
      (let ([res (bfs i)])
        (if (= res -1)
            (set! max-groups -1)
            (when (> res 0)
              (set! max-groups (+ max-groups res)))))))

  (if (= max-groups -1) -1 max-groups))

(define (make-queue) (mcons '() '()))
(define (enqueue! q x)
  (if (null? (mcar q))
      (let ([new-cell (mcons x '())])
        (set-mcar! q new-cell)
        (set-mcdr! q new-cell))
      (let ([new-cell (mcons x '())])
        (set-mcdr! (mcdr q) new-cell)
        (set-mcdr! q new-cell))))
(define (dequeue! q)
  (let ([front (mcar q)])
    (set-mcar! q (mcdr front))
    (when (null? (mcar q)) (set-mcdr! q '()))
    (mcar front)))
(define (queue-empty? q) (null? (mcar q)))
(define (queue-clear! q) (set-mcar! q '()) (set-mcdr! q '()))