#lang racket

(require data/heap)

(define (max-points grid queries)
  (define m (length grid))
  (define n (if (null? grid) 0 (length (car grid))))
  (define dirs '((0 1) (1 0) (0 -1) (-1 0)))
  (define visited (make-hash))
  (define heap (make-heap (lambda (a b) (< (car a) (car b))))))
  (heap-add! heap (cons (list-ref (list-ref grid 0) 0) (cons 0 0)))
  (hash-set! visited (cons 0 0) #t)
  (define res '())
  (for ([q (sort queries <)])
    (define cnt 0)
    (while (and (not (heap-empty? heap)) (< (car (heap-min heap)) q))
      (define cell (heap-remove-min! heap))
      (define val (car cell))
      (define i (car (cdr cell)))
      (define j (cdr (cdr cell)))
      (set! cnt (add1 cnt))
      (for ([dir dirs])
        (define ni (+ i (car dir)))
        (define nj (+ j (cdr dir)))
        (when (and (>= ni 0) (< ni m) (>= nj 0) (< nj n) (not (hash-has-key? visited (cons ni nj))))
          (hash-set! visited (cons ni nj) #t)
          (heap-add! heap (cons (list-ref (list-ref grid ni) nj) (cons ni nj)))))
    (set! res (cons cnt res)))
  (reverse res))