#lang racket

(define/contract (maximize-the-minimum-powered-city stations r k)
  (-> exact-integer? exact-integer? exact-integer? exact-integer?)
  (define n (vector-length stations))
  (define (possible min-power)
    (define stations-copy (vector-copy stations))
    (define added 0)
    (define total 0)
    (define prefix 0)
    (define q (make-queue))
    (for ([i (in-range n)])
      (when (not (queue-empty? q))
        (define front (queue-front q))
        (when (< (car front) (- i r))
          (set! prefix (- prefix (cdr (queue-front q))))
          (queue-dequeue! q))
      (define current (+ (vector-ref stations-copy i) prefix))
      (when (< current min-power)
        (define need (- min-power current))
        (set! added (+ added need))
        (when (> added k)
          (return #f))
        (set! prefix (+ prefix need))
        (queue-enqueue! q (cons (+ i r) need)))
      (>= k added)))
  (define left 0)
  (define right (+ (apply + (vector->list stations)) k))
  (define answer 0)
  (while (<= left right)
    (define mid (quotient (+ left right) 2))
    (if (possible mid)
        (begin
          (set! answer mid)
          (set! left (+ mid 1)))
        (set! right (- mid 1))))
  answer)