(define/contract (minimum-cost nums k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (let ([n (length nums)])
    (let ([dp (make-vector (add1 n) +inf.0)])
      (vector-set! dp 0 0)
      (for ([i (in-range 1 (add1 n))])
        (let ([freq (make-hash)]
              [cost 0])
          (for ([j (in-range i 0 -1)])
            (let ([num (list-ref nums (sub1 j))])
              (hash-update! freq num add1 1)
              (when (= (hash-ref freq num) 2)
                (set! cost (add1 cost)))
              (when (> (hash-ref freq num) 2)
                (set! cost (add1 cost)))
              (vector-set! dp i (min (vector-ref dp i)
                                     (+ (vector-ref dp (sub1 j)) cost k)))))))
      (vector-ref dp n))))