(define/contract (maximize-win prize-pos k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (let* ([n (length prize-pos)]
         [left (make-vector n 0)]
         [right (make-vector n 0)]
    (let loop ([i 0] [j 0])
      (when (< i n)
        (while (and (< j n) (<= (- (list-ref prize-pos j) (list-ref prize-pos i)) k))
          (set! j (+ j 1)))
        (vector-set! left i (- j i))
        (loop (+ i 1) j)))
    (let loop ([i (- n 1)] [j (- n 1)])
      (when (>= i 0)
        (while (and (>= j 0) (<= (- (list-ref prize-pos i) (list-ref prize-pos j)) k))
          (set! j (- j 1)))
        (vector-set! right i (- i j))
        (loop (- i 1) j)))
    (let ([max-right (make-vector n 0)])
      (vector-set! max-right (- n 1) (vector-ref right (- n 1)))
      (for ([i (in-range (- n 2) -1 -1)])
        (vector-set! max-right i (max (vector-ref right i) (vector-ref max-right (+ i 1)))))
    (let ([res 0])
      (for ([i (in-range n)])
        (define end (+ i (vector-ref left i)))
        (if (< end n)
            (set! res (max res (+ (vector-ref left i) (vector-ref max-right end))))
            (set! res (max res (vector-ref left i)))))
      res)))