(define (substring-xor-queries s queries)
  (define (str->num str)
    (if (string=? str "")
        0
        (string->number str 2)))
  (define n (string-length s))
  (define memo (make-hash))
  (for ([i (in-range n)])
    (for ([j (in-range i (min n (+ i 32)))])
      (define substr (substring s i (+ j 1)))
      (define num (str->num substr))
      (unless (hash-has-key? memo num)
        (hash-set! memo num (list i j)))))
  (for/list ([query queries])
    (define val (bitwise-xor (first query) (second query)))
    (hash-ref memo val '(-1 -1)))))