#lang racket

(define (root-count edges guesses k)
  (define n (add1 (length edges)))
  (define adj (make-vector n '()))
  (for ([e edges])
    (let ([u (car e)] [v (cadr e)])
      (vector-set! adj u (cons v (vector-ref adj u)))
      (vector-set! adj v (cons u (vector-ref adj v)))))

  (define guess-set (make-hash))
  (for ([g guesses])
    (hash-set! guess-set g #t))

  (define correct 0)
  (define (dfs u parent)
    (for ([v (vector-ref adj u)])
      (when (not (equal? v parent))
        (when (hash-ref guess-set (list u v) #f)
          (set! correct (add1 correct)))
        (dfs v u))))
  (dfs 0 -1)

  (define res 0)
  (define (re-root u parent cnt)
    (when (>= cnt k)
      (set! res (add1 res)))
    (for ([v (vector-ref adj u)])
      (when (not (equal? v parent))
        (let ([new-cnt cnt])
          (when (hash-ref guess-set (list u v) #f)
            (set! new-cnt (sub1 new-cnt)))
          (when (hash-ref guess-set (list v u) #f)
            (set! new-cnt (add1 new-cnt)))
          (re-root v u new-cnt)))))
  (re-root 0 -1 correct)
  res)