(define/contract (even-odd-bits n)
  (-> exact-integer? (listof exact-integer?))
  (let loop ([n n] [i 0] [even 0] [odd 0])
    (if (zero? n)
        (list even odd)
        (let ([bit (bitwise-and n 1)])
          (if (even? i)
              (loop (arithmetic-shift n -1) (add1 i) (+ even bit) odd)
              (loop (arithmetic-shift n -1) (add1 i) even (+ odd bit)))))))