(define (makeSubarraySumsEqual arr k)
  (let* ((n (length arr))
    (if (= (modulo n k) 0)
        (let ((groups (make-vector k '())))
          (for ([i (in-range n)])
            (let ((group-idx (modulo i k)))
              (vector-set! groups group-idx (cons (list-ref arr i) (vector-ref groups group-idx)))))
          (let ((medians (make-vector k 0)))
            (for ([i (in-range k)])
              (let ((sorted-group (sort (vector-ref groups i) <)))
                (vector-set! medians i (list-ref sorted-group (quotient (length sorted-group) 2)))))
            (let ((total 0)))
              (for ([i (in-range n)])
                (let ((group-idx (modulo i k)))
                  (set! total (+ total (abs (- (list-ref arr i) (vector-ref medians group-idx)))))))
              total))
        0)))