(define (first-complete-index arr mat)
  (define m (length mat))
  (define n (if (null? mat) 0 (length (car mat))))
  (define pos (make-hash))
  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (hash-set! pos (list-ref (list-ref mat i) j) (cons i j))))
  (define row-count (make-vector m 0))
  (define col-count (make-vector n 0))
  (for ([val (in-list arr)]
        [k (in-naturals)])
    (define p (hash-ref pos val))
    (define i (car p))
    (define j (cdr p))
    (vector-set! row-count i (add1 (vector-ref row-count i)))
    (vector-set! col-count j (add1 (vector-ref col-count j)))
    (when (or (= (vector-ref row-count i) n)
              (= (vector-ref col-count j) m))
      (return k)))
  -1)