(define/contract (can-traverse nums)
  (-> (listof exact-integer?) boolean?)
  (let* ([n (length nums)]
         [parent (make-vector n 0)]
         [size (make-vector n 1)]
         [find (lambda (u)
                 (if (= (vector-ref parent u) u)
                     u
                     (let ([root (find (vector-ref parent u))])
                       (vector-set! parent u root)
                       root)))]
         [union (lambda (u v)
                  (let ([root-u (find u)]
                        [root-v (find v)])
                    (unless (= root-u root-v)
                      (if (< (vector-ref size root-u) (vector-ref size root-v))
                          (begin
                            (vector-set! parent root-u root-v)
                            (vector-set! size root-v (+ (vector-ref size root-v) (vector-ref size root-u))))
                          (begin
                            (vector-set! parent root-v root-u)
                            (vector-set! size root-u (+ (vector-ref size root-u) (vector-ref size root-v))))))))])
    (for ([i (in-range n)])
      (vector-set! parent i i))
    (let ([factor-map (make-hash)])
      (for ([(num idx) (in-indexed nums)])
        (let ([factors (get-prime-factors num)])
          (for ([factor factors])
            (if (hash-has-key? factor-map factor)
                (union idx (hash-ref factor-map factor))
                (hash-set! factor-map factor idx))))))
    (let ([root (find 0)])
      (for ([i (in-range 1 n)])
        (unless (= (find i) root)
          (return #f))))
    #t))

(define (get-prime-factors n)
  (let ([factors (mutable-set)])
    (when (even? n)
      (set-add! factors 2)
      (set! n (/ n 2))
      (while (even? n)
        (set! n (/ n 2))))
    (let ([i 3])
      (while (<= (* i i) n)
        (when (zero? (modulo n i))
          (set-add! factors i)
          (set! n (/ n i))
          (while (zero? (modulo n i))
            (set! n (/ n i))))
        (set! i (+ i 2))))
    (when (> n 2)
      (set-add! factors n))
    (set->list factors)))