(define/contract (difference-of-distinct-values grid)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)))
  (define m (length grid))
  (define n (if (null? grid) 0 (length (car grid))))
  (define result (make-list m (make-list n 0)))
  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (define top-left (make-hash))
      (define bottom-right (make-hash))
      (define x (- i 1))
      (define y (- j 1))
      (while (and (>= x 0) (>= y 0))
        (hash-set! top-left (list-ref (list-ref grid x) y) #t)
        (set! x (- x 1))
        (set! y (- y 1)))
      (set! x (+ i 1))
      (set! y (+ j 1))
      (while (and (< x m) (< y n))
        (hash-set! bottom-right (list-ref (list-ref grid x) y) #t)
        (set! x (+ x 1))
        (set! y (+ y 1)))
      (define diff (- (hash-count top-left) (hash-count bottom-right)))
      (list-set! (list-ref result i) j (abs diff))))
  result)