(define (max-increasing-cells mat)
  (define m (length mat))
  (define n (if (zero? m) 0 (length (car mat))))
  (define sorted-list '())
  (for ([i (in-range m)])
    (for ([j (in-range n)])
      (set! sorted-list (cons (cons (list-ref (list-ref mat i) j) (cons i j)) sorted-list))))
  (set! sorted-list (sort sorted-list (lambda (x y) (< (car x) (car y)))))
  (define row-max (make-vector m 0))
  (define col-max (make-vector n 0))
  (define dp (make-vector m (make-vector n 0)))
  (define prev-val -inf.0)
  (define updates '())
  (for ([cell sorted-list])
    (define val (car cell))
    (define i (cadr cell))
    (define j (cddr cell))
    (when (not (= val prev-val))
      (for ([update updates])
        (define ii (car update))
        (define jj (cadr update))
        (define v (caddr update))
        (vector-set! row-max ii (max (vector-ref row-max ii) v))
        (vector-set! col-max jj (max (vector-ref col-max jj) v)))
      (set! updates '())
      (set! prev-val val))
    (define current (max (add1 (vector-ref row-max i)) (add1 (vector-ref col-max j))))
    (vector-set! (vector-ref dp i) j current)
    (set! updates (cons (list i j current) updates)))
  (apply max (map (lambda (row) (apply max (vector->list row))) (vector->list dp)))