(define (sum-distance nums s d)
  (define n (length nums))
  (define mod (expt 10 9))
  (define (add-mod a b)
    (modulo (+ a b) mod))
  (define (sub-mod a b)
    (modulo (- a b) mod))
  (define (mul-mod a b)
    (modulo (* a b) mod))
  (define positions
    (for/list ([num nums] [dir s])
      (if (char=? dir #\R)
          (+ num d)
          (- num d))))
  (set! positions (sort positions <))
  (define prefix (make-vector n 0))
  (vector-set! prefix 0 (list-ref positions 0))
  (for ([i (in-range 1 n)])
    (vector-set! prefix i (add-mod (vector-ref prefix (sub1 i)) (list-ref positions i))))
  (define total 0)
  (for ([i (in-range 1 n)])
    (set! total (add-mod total (sub-mod (mul-mod (list-ref positions i) i) (vector-ref prefix (sub1 i))))))
  total)