(define/contract (good-subset-of-matrix matrix)
  (-> (listof (listof exact-integer?)) (listof exact-integer?))
  (define n (length matrix))
  (define m (if (null? matrix) 0 (length (car matrix)))))
  (define (subset-ok? mask)
    (for/and ([col (in-range m)])
      (zero? (apply bitwise-ior (for/list ([row (in-range n)] 
                                  (if (bitwise-bit-set? mask row) 
                                      (list-ref (list-ref matrix row) col) 
                                      0)))))))
  (for/or ([mask (in-range 1 (arithmetic-shift 1 n))])
    (if (subset-ok? mask)
        (for/list ([i (in-range n)] #:when (bitwise-bit-set? mask i)) i)
        #f))
  '())