(define/contract (special-perm nums)
  (-> (listof exact-integer?) exact-integer?)
  (define n (length nums))
  (define MOD 1000000007)
  (define memo (make-hash))
  (define (dp mask prev)
    (define key (cons mask prev))
    (hash-ref! memo key
      (lambda ()
        (if (= mask (bitwise-not (arithmetic-shift -1 n)))
            1
            (let loop ([i 0] [res 0])
              (if (>= i n)
                  res
                  (if (or (bitwise-bit-set? mask i)
                          (and (not (= prev -1))
                               (not (or (= (modulo prev (list-ref nums i)) 0)
                                        (= (modulo (list-ref nums i) prev) 0))))))
                      (loop (add1 i) res)
                      (loop (add1 i)
                            (modulo (+ res (dp (bitwise-ior mask (arithmetic-shift 1 i))
                                              (list-ref nums i)))
                                    MOD)))))))))))
  (dp 0 -1))