(define/contract (count-servers n logs x queries)
  (-> exact-integer? (listof (listof exact-integer?)) exact-integer? (listof exact-integer?) (listof exact-integer?))
  (define server-counts (make-hash))
  (define active-servers (mutable-set))
  (define sorted-logs (sort logs (lambda (a b) (< (second a) (second b))))
  (define m (length queries))
  (define query-indices (sort (range m) (lambda (i j) (< (list-ref queries i) (list-ref queries j))))
  (define result (make-vector m 0))
  (define left 0)
  (define right 0)
  (define len (length sorted-logs))

  (for ([query-index query-indices])
    (define q (list-ref queries query-index))
    (define start-time (- q x))
    (define end-time q)

    (while (and (< right len) (<= (second (list-ref sorted-logs right)) end-time))
      (define server-id (first (list-ref sorted-logs right)))
      (hash-update! server-counts server-id (lambda (v) (+ v 1)) 0)
      (set-add! active-servers server-id)
      (set! right (+ right 1))

    (while (and (< left len) (< (second (list-ref sorted-logs left)) start-time))
      (define server-id (first (list-ref sorted-logs left)))
      (hash-update! server-counts server-id (lambda (v) (- v 1)) 0)
      (when (= (hash-ref server-counts server-id) 0)
        (set-remove! active-servers server-id)
      (set! left (+ left 1))

    (vector-set! result query-index (- n (set-count active-servers)))
  )

  (for/list ([i (in-range m)])
    (vector-ref result i))
)