(define/contract (longest-odd-even-subarray nums threshold)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length nums))
  (define max-len 0)
  (define current-len 0)
  (for ([i (in-range n)])
    (if (and (<= (list-ref nums i) threshold)
             (or (= current-len 0)
                 (not (= (modulo (list-ref nums i) 2) 
                         (modulo (list-ref nums (- i 1)) 2)))))
        (begin
          (set! current-len (+ current-len 1))
          (set! max-len (max max-len current-len)))
        (if (<= (list-ref nums i) threshold)
            (set! current-len 1)
            (set! current-len 0))))
  (if (> max-len 0) max-len 0))