(define/contract (num-squares n)
  (-> exact-integer? exact-integer?)
  (let ([dp (make-vector (+ n 1) +inf.0)])
    (vector-set! dp 0 0)
    (for ([i (in-range 1 (+ n 1))])
      (for ([j (in-range 1 (+ (inexact->exact (floor (sqrt i))) 1))])
        (let ([square (* j j)])
          (when (>= i square)
            (vector-set! dp i (min (vector-ref dp i) (+ (vector-ref dp (- i square)) 1)))))))
    (vector-ref dp n)))