#lang racket

(define/contract (maximum-safeness-factor grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define n (length grid))
  (define m (if (null? grid) 0 (length (car grid))))
  (define dirs '((0 . 1) (1 . 0) (0 . -1) (-1 . 0)))

  (define (valid? i j)
    (and (>= i 0) (< i n) (>= j 0) (< j m)))

  (define q (make-queue))
  (define dist (make-vector n (make-vector m +inf.0)))

  (for ([i (in-range n)])
    (for ([j (in-range m)])
      (when (= (list-ref (list-ref grid i) j) 1)
        (vector-set! (vector-ref dist i) j 0)
        (enqueue! q (cons i j)))))

  (let loop ()
    (unless (queue-empty? q)
      (define cell (dequeue! q))
      (define i (car cell))
      (define j (cdr cell))
      (for ([dir (in-list dirs)])
        (define ni (+ i (car dir)))
        (define nj (+ j (cdr dir)))
        (when (valid? ni nj)
          (define new-dist (+ (vector-ref (vector-ref dist i) j) 1))
          (when (< new-dist (vector-ref (vector-ref dist ni) nj))
            (vector-set! (vector-ref dist ni) nj new-dist)
            (enqueue! q (cons ni nj)))))
    (loop))

  (define max-heap (make-heap (lambda (a b) (> (car a) (car b)))))
  (heap-add! max-heap (cons (vector-ref (vector-ref dist 0) 0) (cons 0 0)))
  (define visited (make-vector n (make-vector m #f)))
  (vector-set! (vector-ref visited 0) 0 #t)

  (let loop ()
    (define cell (heap-min max-heap))
    (heap-remove! max-heap)
    (define d (car cell))
    (define i (car (cdr cell)))
    (define j (cdr (cdr cell)))
    (when (and (= i (- n 1)) (= j (- m 1)))
      (return d))
    (for ([dir (in-list dirs)])
      (define ni (+ i (car dir)))
      (define nj (+ j (cdr dir)))
      (when (valid? ni nj)
        (unless (vector-ref (vector-ref visited ni) nj)
          (vector-set! (vector-ref visited ni) nj #t)
          (heap-add! max-heap (cons (min d (vector-ref (vector-ref dist ni) nj)) (cons ni nj))))))
    (loop))

  0)