(define (add-operators num target)
  (define results '())
  (define (dfs num path value prev)
    (when (null? num)
      (when (= value target)
        (set! results (cons (list->string path) results)))
      (void))
    (for ([i (in-range 1 (add1 (length num)))])
      (let* ([current-str (take num i)]
             [current-num (string->number (list->string current-str))])
        (when (and (not (and (> (length current-str) 1) (char=? (car current-str) #\0)))
                   (not (null? current-str)))
          (if (null? path)
              (dfs (drop num i) current-str current-num current-num)
              (begin
                (dfs (drop num i) (append path (list #\+) current-str) (+ value current-num) current-num)
                (dfs (drop num i) (append path (list #\-) current-str) (- value current-num) (- current-num))
                (dfs (drop num i) (append path (list #\*) current-str) (+ (- value prev) (* prev current-num)) (* prev current-num))))))))
  (dfs (string->list num) '() 0 0)
  (reverse results))