(define/contract (get-max-value n edges k)
  (-> exact-integer? (listof (listof exact-integer?)) exact-integer? exact-integer?)
  (define m (make-vector n 0))
  (define next (make-vector n (make-vector 30 0)))
  (define value (make-vector n (make-vector 30 0)))

  (for ([edge edges])
    (vector-set! m (first edge) (second edge))
    (vector-set! (vector-ref next (first edge)) 0 (second edge))
    (vector-set! (vector-ref value (first edge)) 0 (second edge)))

  (for ([j (in-range 1 30)])
    (for ([i (in-range n)])
      (define prev (vector-ref (vector-ref next i) (- j 1)))
      (vector-set! (vector-ref next i) j (vector-ref (vector-ref next prev) (- j 1)))
      (vector-set! (vector-ref value i) j (+ (vector-ref (vector-ref value i) (- j 1))
                                           (vector-ref (vector-ref value prev) (- j 1))))))

  (define max-val 0)
  (for ([i (in-range n)])
    (define current i)
    (define total 0)
    (define remaining k)
    (for ([j (in-range 29 -1 -1)])
      (when (>= remaining (expt 2 j))
        (set! total (+ total (vector-ref (vector-ref value current) j)))
        (set! current (vector-ref (vector-ref next current) j))
        (set! remaining (- remaining (expt 2 j)))))
    (set! max-val (max max-val total)))

  max-val)