(define (number-of-points cars)
  (define intervals (sort cars (lambda (a b) (< (car a) (car b)))))
  (define merged '())
  (for ([interval intervals])
    (if (null? merged)
        (set! merged (list interval))
        (let ([last-interval (car merged)])
          (if (<= (car interval) (cadr last-interval))
              (set! merged (cons (list (car last-interval) (max (cadr last-interval) (cadr interval))) (cdr merged)))
              (set! merged (cons interval merged))))))
  (apply + (map (lambda (x) (+ 1 (- (cadr x) (car x)))) merged)))