#lang racket

(define (maximum-sum-of-heights maxHeights)
  (define n (length maxHeights))
  (define (left-heights lst)
    (define stack '())
    (define res (make-list n 0))
    (for ([i (in-range n)])
      (while (and (not (null? stack)) (> (list-ref lst i) (list-ref lst (car stack))))
        (set! stack (cdr stack)))
      (if (null? stack)
          (list-set! res i (* (list-ref lst i) (+ i 1)))
          (list-set! res i (+ (list-ref res (car stack)) (* (list-ref lst i) (- i (car stack)))))
      (set! stack (cons i stack)))
    res)

  (define (right-heights lst)
    (define stack '())
    (define res (make-list n 0))
    (for ([i (in-range (- n 1) -1 -1)])
      (while (and (not (null? stack)) (> (list-ref lst i) (list-ref lst (car stack))))
        (set! stack (cdr stack)))
      (if (null? stack)
          (list-set! res i (* (list-ref lst i) (- n i)))
          (list-set! res i (+ (list-ref res (car stack)) (* (list-ref lst i) (- (car stack) i)))))
      (set! stack (cons i stack)))
    res)

  (define left (left-heights maxHeights))
  (define right (right-heights maxHeights))
  (define max-sum 0)
  (for ([i (in-range n)])
    (set! max-sum (max max-sum (+ (list-ref left i) (list-ref right i) (- (list-ref maxHeights i))))))
  max-sum)