(define/contract (maximum-sum-of-heights max-heights)
  (-> (listof exact-integer?) exact-integer?)
  (define n (length max-heights))
  (define (solve)
    (define left (make-vector n 0))
    (define stack (list))
    (for ([i (in-range n)])
      (while (and (not (empty? stack)) (<= (list-ref max-heights (car stack)) (list-ref max-heights i)))
        (set! stack (cdr stack)))
      (if (empty? stack)
          (vector-set! left i (* (list-ref max-heights i) (add1 i)))
          (vector-set! left i (+ (vector-ref left (car stack)) (* (list-ref max-heights i) (- i (car stack))))))
      (set! stack (cons i stack)))
    (define right (make-vector n 0))
    (set! stack (list))
    (for ([i (in-range (sub1 n) -1 -1])
      (while (and (not (empty? stack)) (<= (list-ref max-heights (car stack)) (list-ref max-heights i)))
        (set! stack (cdr stack)))
      (if (empty? stack)
          (vector-set! right i (* (list-ref max-heights i) (- n i)))
          (vector-set! right i (+ (vector-ref right (car stack)) (* (list-ref max-heights i) (- (car stack) i)))))
      (set! stack (cons i stack)))
    (define res 0)
    (for ([i (in-range n)])
      (set! res (max res (+ (vector-ref left i) (vector-ref right i) (- (list-ref max-heights i))))))
    res)
  (solve))