(define/contract (maximize-square-sum nums k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define nums-vec (list->vector nums))
  (define n (vector-length nums-vec))
  (define (apply-operations k)
    (when (> k 0)
      (define min-index (for/fold ([min-i 0] [min-val (vector-ref nums-vec 0)])
                                  ([i (in-range 1 n)])
                          (define val (vector-ref nums-vec i))
                          (if (< val min-val)
                              (values i val)
                              (values min-i min-val))))
      (vector-set! nums-vec min-index (- (vector-ref nums-vec min-index)))
      (apply-operations (- k 1))))
  (apply-operations k)
  (modulo (for/sum ([num (in-vector nums-vec)]) (* num num)) 1000000007))