(define/contract (minimum-sum nums)
  (-> (listof exact-integer?) exact-integer?)
  (let ([n (length nums)])
    (let ([left (make-vector n 0)]
          [right (make-vector n 0)])
      (vector-set! left 0 (list-ref nums 0))
      (for ([i (in-range 1 n)])
        (vector-set! left i (min (vector-ref left (- i 1)) (list-ref nums i)))
      (vector-set! right (- n 1) (list-ref nums (- n 1)))
      (for ([i (in-range (- n 2) -1 -1)])
        (vector-set! right i (min (vector-ref right (+ i 1)) (list-ref nums i)))
      (let ([min-sum +inf.0])
        (for ([j (in-range 1 (- n 1))])
          (let ([i-val (vector-ref left (- j 1))]
                [k-val (vector-ref right (+ j 1))])
            (if (and (< i-val (list-ref nums j)) (< k-val (list-ref nums j)))
                (set! min-sum (min min-sum (+ i-val (list-ref nums j) k-val)))
                #f)))
        (if (= min-sum +inf.0) -1 min-sum)))))