(define (find-champion n edges)
  (let ((indegree (make-vector n 0)))
    (for-each (lambda (edge)
                (let ((to (cadr edge)))
                  (vector-set! indegree to (+ (vector-ref indegree to) 1))))
              edges)
    (let loop ((i 0) (champion -1))
      (cond
        ((= i n) (if (= champion -1) -1 champion))
        ((= (vector-ref indegree i) 0)
         (if (= champion -1)
             (loop (+ i 1) i)
             -1))
        (else (loop (+ i 1) champion)))))))