(define/contract (find-minimum-operations s1 s2 s3)
  (-> string? string? string? exact-integer?)
  (define (common-prefix-length s1 s2 s3)
    (let loop ((i 0))
      (if (and (< i (string-length s1))
               (< i (string-length s2))
               (< i (string-length s3))
               (char=? (string-ref s1 i) (string-ref s2 i))
               (char=? (string-ref s2 i) (string-ref s3 i)))
          (loop (+ i 1))
          i)))
  (let ((l (common-prefix-length s1 s2 s3)))
    (if (zero? l)
        -1
        (+ (- (string-length s1) l)
           (- (string-length s2) l)
           (- (string-length s3) l)))))