(define (beautiful-substrings s k)
  (define n (string-length s))
  (define (vowel? c)
    (member c '(#\a #\e #\i #\o #\u)))
  (let loop ([i 0] [count 0])
    (if (>= i n)
        count
        (let ([vowels 0] [consonants 0])
          (let inner-loop ([j i])
            (if (>= j n)
                (loop (+ i 1) count)
                (let ([c (string-ref s j)])
                  (if (vowel? c)
                      (set! vowels (+ vowels 1))
                      (set! consonants (+ consonants 1)))
                  (if (and (= vowels consonants) (zero? (modulo (* vowels consonants) k)))
                      (inner-loop (+ j 1) (+ count 1))
                      (inner-loop (+ j 1) count))))))))))