(define (count-complete-substrings word k)
  (define n (string-length word))
  (define (distinct-chars s)
    (define seen (make-hash))
    (for ([c (in-string s)])
      (hash-set! seen c #t))
    (hash-count seen))
  (define (valid-substring? s)
    (define len (string-length s))
    (define m (/ len k))
    (define freq (make-hash))
    (for ([c (in-string s)])
      (hash-update! freq c add1 0))
    (and (zero? (modulo len k))
         (for/and ([(c cnt) (in-hash freq)])
           (= cnt m)))))
  (let loop ([i 0] [res 0])
    (if (>= i n)
        res
        (let ([max-j (min n (+ i (* 26 k)))])
          (let inner ([j (+ i 1)] [res res])
            (if (> j max-j)
                (loop (+ i 1) res)
                (let ([sub (substring word i j)])
                  (if (valid-substring? sub)
                      (inner (+ j 1) (+ res 1))
                      (inner (+ j 1) res)))))))))