#lang racket

(define (incremovable-subarrays nums)
  (define n (length nums))
  (define (prefix-ok? i)
    (or (zero? i)
        (and (< (list-ref nums (sub1 i)) (list-ref nums i))
             (prefix-ok? (sub1 i)))))
  (define (suffix-ok? i)
    (or (= i (sub1 n))
        (and (< (list-ref nums i) (list-ref nums (add1 i)))
             (suffix-ok? (add1 i)))))
  (define (binary-search-left left right target)
    (let loop ([l left] [r right])
      (if (> l r)
          l
          (let ([mid (quotient (+ l r) 2)])
            (if (< (list-ref nums mid) target)
                (loop (add1 mid) r)
                (loop l (sub1 mid)))))))
  (define (binary-search-right left right target)
    (let loop ([l left] [r right])
      (if (> l r)
          r
          (let ([mid (quotient (+ l r) 2)])
            (if (> (list-ref nums mid) target)
                (loop l (sub1 mid))
                (loop (add1 mid) r))))))
  (let* ([prefix-len 0])
    (let loop ([i 0])
      (if (and (< i n) (or (zero? i) (< (list-ref nums (sub1 i)) (list-ref nums i))))
          (begin
            (set! prefix-len (add1 i))
            (loop (add1 i)))
          prefix-len)))
  (let* ([suffix-len 0])
    (let loop ([i (sub1 n)])
      (if (and (>= i 0) (or (= i (sub1 n)) (< (list-ref nums i) (list-ref nums (add1 i))))
          (begin
            (set! suffix-len (add1 (- n i)))
            (loop (sub1 i)))
          suffix-len)))
  (if (= prefix-len n)
      (quotient (* n (add1 n)) 2)
      (let* ([res 0]
             [left 0]
             [right (sub1 n)])
        (for ([i (in-range prefix-len)])
          (set! left (binary-search-left (add1 prefix-len) (sub1 n) (list-ref nums i)))
          (set! res (+ res (- n left))))
        (for ([i (in-range (- n suffix-len) n)])
          (set! right (binary-search-right 0 (- n suffix-len 1) (list-ref nums i)))
          (set! res (+ res (add1 right))))
        (+ res (quotient (* prefix-len (add1 prefix-len)) 2) (quotient (* suffix-len (add1 suffix-len)) 2) 1))))