(define/contract (maximum-length s)
  (-> string? exact-integer?)
  (define n (string-length s))
  (define freq (make-hash))
  (for ([i (in-range n)])
    (define c (string-ref s i))
    (define j i)
    (while (and (< j n) (equal? (string-ref s j) c))
      (set! j (add1 j)))
    (define len (- j i))
    (hash-update! freq c (lambda (v) (cons len v)) (list))
  (define max-len 0)
  (for ([(k v) (in-hash freq)])
    (define sorted (sort v >))
    (define candidates (take sorted (min 3 (length sorted))))
    (define total (if (>= (length candidates) 3)
                      (list-ref candidates 2)
                      (if (>= (length candidates) 2)
                          (sub1 (list-ref candidates 1))
                          (sub1 (list-ref candidates 0)))))
    (set! max-len (max max-len total)))
  (if (> max-len 0) max-len 0))