(define/contract (beautiful-indices s a b k)
  (-> string? string? string? exact-integer? (listof exact-integer?))
  (define (kmp pattern text)
    (define lps (make-vector (string-length pattern) 0))
    (define (compute-lps)
      (let loop ([len 0] [i 1])
        (when (< i (string-length pattern))
        (if (char=? (string-ref pattern i) (string-ref pattern len))
            (begin
              (vector-set! lps i (+ len 1))
              (loop (+ len 1) (+ i 1)))
            (if (zero? len)
                (begin
                  (vector-set! lps i 0)
                  (loop len (+ i 1)))
                (loop (vector-ref lps (- len 1)) len)))))
    (compute-lps)
    (define result '())
    (let loop ([i 0] [j 0])
      (when (< i (string-length text))
      (if (char=? (string-ref text i) (string-ref pattern j))
          (begin
            (set! i (+ i 1))
            (set! j (+ j 1))
            (when (= j (string-length pattern))
              (set! result (cons (- i j) result))
              (set! j (vector-ref lps (- j 1)))))
            (loop i j))
          (if (zero? j)
              (begin
                (set! i (+ i 1))
              (set! j (vector-ref lps (- j 1))))
              (loop i j))))
    (reverse result))

  (define a-indices (kmp a s))
  (define b-indices (kmp b s))
  (define result '())
  (for ([i a-indices])
    (define found #f)
    (for ([j b-indices] #:break found)
      (when (<= (abs (- i j)) k)
        (set! found #t)
        (set! result (cons i result)))))
  (reverse result))