(define/contract (beautiful-indices s a b k)
  (-> string? string? string? exact-integer? (listof exact-integer?))
  (define (kmp pattern text)
    (define lps (make-vector (string-length pattern) 0))
    (define (compute-lps)
      (let loop ([len 0] [i 1])
        (when (< i (string-length pattern))
          (if (char=? (string-ref pattern i) (string-ref pattern len))
              (begin
                (vector-set! lps i (+ len 1))
                (loop (+ len 1) (+ i 1)))
              (if (zero? len)
                  (begin
                    (vector-set! lps i 0)
                    (loop len (+ i 1)))
                  (loop (vector-ref lps (- len 1)) i))))))
    (compute-lps)
    (define matches '())
    (let loop ([i 0] [j 0])
      (when (< i (string-length text))
        (if (char=? (string-ref text i) (string-ref pattern j))
            (begin
              (set! i (+ i 1))
              (set! j (+ j 1))
              (when (= j (string-length pattern))
                (set! matches (cons (- i j) matches))
                (set! j (vector-ref lps (- j 1)))))
            (if (zero? j)
                (set! i (+ i 1))
                (set! j (vector-ref lps (- j 1))))))
      (reverse matches)))

  (define a-indices (kmp a s))
  (define b-indices (kmp b s))
  (define result '())
  (define (binary-search lst target)
    (let loop ([low 0] [high (sub1 (length lst))])
      (if (> low high)
          high
          (let ([mid (quotient (+ low high) 2)])
            (if (>= (list-ref lst mid) target)
                (loop low (sub1 mid))
                (loop (add1 mid) high))))))

  (for ([i a-indices])
    (define left (max 0 (- i k)))
    (define right (+ i k))
    (define idx (binary-search b-indices left))
    (when (and (>= idx 0) (< idx (length b-indices)))
      (define j (list-ref b-indices idx))
      (when (and (>= j left) (<= j right))
        (set! result (cons i result)))))
  (reverse result))