(define (maximum-subarray nums k)
  (define n (vector-length nums))
  (define prefix (make-vector (+ n 1) 0))
  (for ([i (in-range n)])
    (vector-set! prefix (+ i 1) (+ (vector-ref prefix i) (vector-ref nums i))))

  (define min-prefix (make-hash))
  (hash-set! min-prefix (modulo (vector-ref prefix 0) k) (vector-ref prefix 0))

  (define max-sum -inf.0)
  (for ([i (in-range 1 (+ n 1))])
    (define current (vector-ref prefix i))
    (define rem (modulo current k))
    (when (hash-has-key? min-prefix rem)
      (define sum (- current (hash-ref min-prefix rem)))
      (when (> sum max-sum)
        (set! max-sum sum)))
    (if (hash-has-key? min-prefix rem)
        (when (< current (hash-ref min-prefix rem))
          (hash-set! min-prefix rem current))
        (hash-set! min-prefix rem current)))
  (if (= max-sum -inf.0) 0 max-sum))