(define/contract (number-of-ways-to-place-people points)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define sorted-points (sort points (λ (a b) (or (< (first a) (first b)) (and (= (first a) (first b)) (< (second a) (second b))))))
  (define n (length sorted-points))
  (define count 0)
  (for ([i (in-range n)])
    (for ([j (in-range (add1 i) n)])
      (define x1 (first (list-ref sorted-points i)))
      (define y1 (second (list-ref sorted-points i)))
      (define x2 (first (list-ref sorted-points j)))
      (define y2 (second (list-ref sorted-points j)))
      (define valid #t)
      (for ([k (in-range n)] #:break (not valid))
        (define x (first (list-ref sorted-points k)))
        (define y (second (list-ref sorted-points k)))
        (when (and (<= x1 x x2) (>= y1 y y2) (not (and (= x x1) (= y y1))) (not (and (= x x2) (= y y2))))
          (set! valid #f)))
      (when valid (set! count (add1 count)))))
  count)