(define (count-prefix-suffix-pairs words)
  (define n (length words))
  (define count 0)
  (for ([i (in-range n)])
    (for ([j (in-range (add1 i) n)])
      (define word-i (list-ref words i))
      (define word-j (list-ref words j))
      (define len-i (string-length word-i))
      (define len-j (string-length word-j))
      (when (and (<= len-i len-j)
                 (equal? (substring word-j 0 len-i) word-i)
                 (equal? (substring word-j (- len-j len-i) len-j) word-i))
        (set! count (add1 count)))))
  count)