#lang racket

(define (minimum-operations-to-write-y grid)
  (define n (length grid))
  (define half (quotient n 2))
  (define (is-y? i j)
    (or (and (= i j) (< i half))
        (and (= (+ i j) (- n 1)) (< i half))
        (and (>= i half) (= j (quotient n 2))))
  (define (count-values)
    (define y-count (make-hash))
    (define other-count (make-hash))
    (for* ([i (in-range n)]
           [j (in-range n)])
      (define val (list-ref (list-ref grid i) j))
      (if (is-y? i j)
          (hash-update! y-count val add1 0)
          (hash-update! other-count val add1 0)))
    (values y-count other-count))
  (define-values (y-count other-count) (count-values))
  (define (min-operations)
    (define min-ops +inf.0)
    (for* ([a (in-range 3)]
           [b (in-range 3)]
           #:unless (= a b))
      (define ops 0)
      (for ([(val cnt) (in-hash y-count)])
        (unless (= val a)
          (set! ops (+ ops cnt))))
      (for ([(val cnt) (in-hash other-count)])
        (unless (= val b)
          (set! ops (+ ops cnt))))
      (when (< ops min-ops)
        (set! min-ops ops)))
    min-ops)
  (min-operations))