(define/contract (sum-of-power nums k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define mod 1000000007)
  (define n (length nums))
  (define dp (make-vector (+ k 1) 0))
  (vector-set! dp 0 1)
  (for ([num (in-list nums)])
    (for ([i (in-range k (- -1 num) -1)])
      (vector-set! dp i (modulo (+ (vector-ref dp i) (vector-ref dp (- i num))) mod))))
  (define total 0)
  (define pow 1)
  (for ([i (in-range 1 (+ n 1))])
    (set! pow (modulo (* pow 2) mod))
    (set! total (modulo (+ total (* (vector-ref dp k) pow)) mod)))
  total)