(define/contract (maximum-length-substring s)
  (-> string? exact-integer?)
  (define n (string-length s))
  (define max-len 0)
  (for ([i (in-range n)])
    (define freq (make-hash))
    (for ([j (in-range i n)])
      (define c (string-ref s j))
      (hash-update! freq c add1 0)
      (when (andmap (lambda (v) (<= v 2)) (hash-values freq))
        (set! max-len (max max-len (- (+ j 1) i)))))
  max-len)