(define (find-edges n edges src dst)
  (define adj (make-vector n '()))
  (for ([e edges])
    (let ([u (car e)] [v (cadr e)] [w (caddr e)])
      (vector-set! adj u (cons (list v w) (vector-ref adj u)))
      (vector-set! adj v (cons (list u w) (vector-ref adj v)))))

  (define (dijkstra s)
    (define dist (make-vector n +inf.0))
    (define heap (make-heap (lambda (a b) (< (car a) (car b)))))
    (vector-set! dist s 0)
    (heap-add! heap (list 0 s))
    (while (not (heap-empty? heap))
      (let ([curr (heap-remove! heap)])
        (let ([d (car curr)] [u (cadr curr)])
          (when (<= d (vector-ref dist u))
            (for ([neighbor (vector-ref adj u)])
              (let ([v (car neighbor)] [w (cadr neighbor)])
                (when (> (vector-ref dist v) (+ d w))
                  (vector-set! dist v (+ d w))
                  (heap-add! heap (list (vector-ref dist v) v)))))))))
    dist)

  (define dist-src (dijkstra src))
  (define dist-dst (dijkstra dst))
  (define total (vector-ref dist-src dst))
  (define result (make-list (length edges) #f))

  (for ([i (in-range (length edges))] [e edges])
    (let ([u (car e)] [v (cadr e)] [w (caddr e)])
      (when (or (equal? (+ (vector-ref dist-src u) w (vector-ref dist-dst v)) total)
                (equal? (+ (vector-ref dist-src v) w (vector-ref dist-dst u)) total))
        (list-set! result i #t)))
  result)