(define/contract (count-triangles grid)
  (-> (listof (listof char?)) exact-integer?)
  (define rows (length grid))
  (define cols (if (null? grid) 0 (length (car grid))))
  (define row-count (make-vector rows 0))
  (define col-count (make-vector cols 0))

  (for ([i (in-range rows)])
    (for ([j (in-range cols)])
      (when (char=? (list-ref (list-ref grid i) j) #\1)
        (vector-set! row-count i (add1 (vector-ref row-count i)))
        (vector-set! col-count j (add1 (vector-ref col-count j)))))

  (define result 0)
  (for ([i (in-range rows)])
    (for ([j (in-range cols)])
      (when (char=? (list-ref (list-ref grid i) j) #\1)
        (set! result (+ result (* (sub1 (vector-ref row-count i)) (sub1 (vector-ref col-count j))))))))
  result)